BEM.DOM.decl({ block: 'level', modName: 'type', modVal: 'journal' }, {
    onSetMod: {
        js: {
            inited: function () {
                var yaShare = this.findBlockInside('ya-share2');

                this._chatHeader = this.findElem('chat-header');

                if (yaShare) {
                    this._initShare(yaShare);
                }

                if (this._chatHeader) {
                    this._chat = this.findElem('chat-content');
                    this.bindTo(this._chatHeader, 'pointerclick', this._toggleChat.bind(this));
                }

                if (!this.params.metrikaGoalId) {
                    return;
                }

                this._scrollHandler = $.debounce(this._detectScroll.bind(this), 300);

                this.bindToWin('scroll', this._scrollHandler);

                this._detectScroll();
            }
        }
    },

    _initShare: function (shareBlock) {
        var mods = shareBlock.getMods();

        if (mods.inited) {
            return;
        }

        Ya.share2(shareBlock.domElem[0], {
            content: {
                url: this.params.shareUrl,
                title: this.params.og.title,
                description: this.params.og.description,
                image: this.params.og.image
            }
        });
    },

    /**
     * Считаем, что пользователь увидел этаж, когда он проскролил 80% высоты блока.
     * Когда пользователь увидел этаж, отправляем цель в метрику
     * @private
     */
    _detectScroll: function () {
        BEM.blocks['i-bem']
            .detectScrollEnd
            .call(this, this.domElem, this.params.metrikaGoalId, this._scrollHandler, 0.8);
    },

    _toggleChat: function() {
        this.toggleMod(this._chatHeader, 'opened', 'yes');
        this.toggleMod(this._chat, 'opened', 'yes');
    }
});
