module.exports = function (bh) {
    'use strict';
    bh.match('level_type_news', function (ctx, json) {
        var items = json.level.items;
        var columns = {
            big: items.slice(0, 2),
            small: items.slice(2)
        };

        var content = {
            elem: 'content',
            elemMods: { type: 'news' },
            mobileLink: json.level.mobileLink,
            columns: [
                columns.big.map(function (item) {
                    return {
                        block: 'level-card',
                        mods: !bh.lib.global.isMobile && {
                            type: 'news-big'
                        },
                        link: {
                            prefix: json.newsPage,
                            slug: item.link,
                            url: item.url,
                            text: item.text
                        },
                        commentsData: bh.lib.util.getCommentsCount(json.commentsData, item.link),
                        date: item.date,
                        additional: item.additional
                    };
                }),
                columns.small.map(function (item) {
                    return {
                        block: 'level-card',
                        mods: !bh.lib.global.isMobile && {
                            type: 'news-small'
                        },
                        link: {
                            prefix: json.newsPage,
                            slug: item.link,
                            url: item.url,
                            text: item.text
                        },
                        commentsData: bh.lib.util.getCommentsCount(json.commentsData, item.link),
                        date: item.date
                    };
                })
            ]
        };

        ctx.content([
            content,
            ctx.content()
        ], true);
    });
};
