module.exports = function (bh) {
    var sortServices = function (thisService, thatService) {
        return thisService.order - thatService.order;
    };

    bh.match('level_type_online-edu-services', function (ctx, json) {
        var level = json.level;
        var image = level.backgroundImage;

        ctx
            .attrs({
                style: image && 'background-image: url(' + image + ');'
            })
            .content([
                {
                    elem: 'title',
                    content: level.levelTitle
                },
                {
                    elem: 'text',
                    content: level.description
                },
                {
                    elem: 'carousel-wrapper',
                    services: json.services
                }
            ]);
    });

    bh.match('level_type_online-edu-services__carousel-wrapper', function (ctx, json) {
        var isMobile = bh.lib.global.isMobile;
        var services = json.services;

        ctx.content(services ? {
            block: 'owl-carousel',
            mods: { type: 'arrows', 'nav-borders': 'no' },
            js: {
                options: {
                    responsive: isMobile && {
                        0: {
                            items: 1
                        },
                        300: {
                            items: 2
                        },
                        590: {
                            items: 3
                        },
                        880: {
                            items: 4
                        }
                    },
                    rewind: false,
                    nav: !isMobile,
                    loop: isMobile,
                    margin: 10
                }
            },
            content: [
                services
                    .sort(sortServices)
                    .map(function (service) {
                        return {
                            block: 'online-service',
                            service: service
                        };
                    }),
                // Для того, чтобы последний сервис не был скрыт
                !isMobile && {
                    block: 'level',
                    elem: 'fake-service'
                }
            ]
        } : null);
    });
};
