module.exports = function (bh) {
    bh.match('level_type_publishers', function (ctx, json) {
        var publishers = json.level.publishers;

        ctx.content({
            elem: 'scrollable',
            content: publishers && publishers.map(function (publisher) {
                return {
                    elem: 'publisher',
                    publisher: publisher
                };
            })
        });
    });

    bh.match('level__publisher', function (ctx, json) {
        var publisher = json.publisher;
        var imageUrl = publisher.imageUrl;
        var color = publisher.color;

        ctx
            .tag('a')
            .attrs({ href: publisher.url })
            .content([
                {
                    elem: 'image',
                    attrs: {
                        style: 'background-image: url("' + imageUrl +
                            '"); background-color: ' + color
                    }
                },
                {
                    elem: 'text',
                    name: publisher.name,
                    description: publisher.description
                }
            ]);
    });

    bh.match('level__text', function (ctx, json) {
        ctx.content([
            {
                elem: 'name',
                content: json.name
            },
            {
                elem: 'description',
                content: json.description
            }
        ]);
    });
};
