module.exports = function (bh) {
    bh.match('level_type_sharing', function (ctx, json) {
        var level = json.level;

        if (!level) {
            return '';
        }

        ctx.content([
            level.label && {
                elem: 'title',
                mix: { block: 'html-content' },
                content: level.label
            },
            level.og && {
                elem: 'share',
                content: {
                    block: 'share',
                    mods: { size: 'l' },
                    ogData: level.og
                }
            }
        ]);
    });
};
