module.exports = function (bh) {
    bh.match('level_type_showcase', function (ctx, json) {
        var productTypes = ['red', 'yellow', 'blue'];
        var products = randomizeAndPickProducts(json.level.items, productTypes);
        var productsMetrikaGoalIds = generateMetrikaObject(products, productTypes);

        ctx
            .js(
                {
                    productsTypes: productTypes,
                    reachMetrikaGoalId: json.level.metrikaGoalId,
                    productsMetrikaGoalIds: productsMetrikaGoalIds,
                    ctaMetrikaGoalId: json.level.cta.metrikaGoalId
                }
            )
            .content([
                {
                    elem: 'content',
                    productsTypes: productTypes,
                    products: products,
                    cta: json.level.cta
                },
                ctx.content()
            ], true);
    });

    bh.match('level_type_showcase__content', function (ctx, json) {
        ctx.content([
            json.productsTypes.map(function(key) {
                var product = json.products[key];

                return {
                    elem: 'product',
                    elemMods: { color: key },
                    product: product
                };
            }),
            json.cta && {
                elem: 'cta',
                cta: json.cta
            },
            ctx.content()
        ], true);
    });

    function generateMetrikaObject(products, keys) {
        return keys.reduce(function(acc, key) {
            var product = products[key];

            if (product && product.metrikaGoalId) {
                acc[key] = product.metrikaGoalId;
            }

            return acc;
        }, {});
    }

    function randomizeAndPickProducts(products, keys) {
        return keys.reduce(function(acc, key) {
            var productOptions = products[key];

            if (productOptions && productOptions.length > 0) {
                var randomIndex = getRandomInt(0, productOptions.length);

                acc[key] = productOptions[randomIndex];
            }

            return acc;
        }, {});
    }

    function getRandomInt(min, max) {
        return Math.floor(Math.random() * (max - min)) + min;
    }
};

