BEM.DOM.decl({ block: 'level', modName: 'type', modVal: 'showcase' }, {
    onSetMod: {
        js: {
            inited: function () {
                this.reachMetrikaGoalId = this.params.reachMetrikaGoalId;
                this.productsMetrikaGoalIds = this.params.productsMetrikaGoalIds;
                this.productsTypes = this.params.productsTypes;
                this.ctaMetrikaGoalId = this.params.ctaMetrikaGoalId;

                if (this.reachMetrikaGoalId) {
                    this._scrollHandler = $.debounce(this._detectScroll.bind(this), 300);

                    this.bindToWin('scroll', this._scrollHandler);

                    this._detectScroll();
                }

                this._bindProducts( this.productsMetrikaGoalIds, this.productsTypes);
                this._bindCta();
            }
        }
    },

    _bindProducts: function (productsMetrikaGoalIds, productsTypes) {
        for (var i = 0; i < productsTypes.length; i += 1) {
            var type = productsTypes[i];
            var productElem = this.findElem('product', 'color', type);

            if (!productElem) {
                continue;
            }

            this.bindTo(productElem, 'pointerclick', this._onProductClick.bind(this, type));
        }
    },

    _bindCta: function() {
        var ctaElem = this.findElem('cta');

        if (!ctaElem) {
            return;
        }

        var button = this.findBlockInside(ctaElem, 'button2');

        if (!button) {
            return;
        }

        this.bindTo(button.domElem, 'pointerclick', this._onCtaButtonClick.bind(this));
    },

    _onProductClick: function (type) {
        this._metrikaReachGoal(this.productsMetrikaGoalIds[type]);
    },

    _onCtaButtonClick: function () {
        this._metrikaReachGoal(this.ctaMetrikaGoalId);
    },

    _metrikaReachGoal: function (goalId) {
        if (goalId) {
            BEM.blocks.metrika.reachGoal(goalId);
        }
    },

    /**
     * Скролл до элемента
     */
    _detectScroll: function () {
        BEM.blocks['i-bem']
            .detectScrollEnd
            .call(this, this.domElem, this.reachMetrikaGoalId, this._scrollHandler, 0.8);
    }
});
