module.exports = function (bh) {
    'use strict';
    function getColumnBemJson(newsPage, commentsCount, column) {
        return column.map(function (item) {
            var type = null;

            if (item.image) {
                type = 'image';
            } else if (column.length === 1) {
                type = 'single';
            }

            return {
                block: 'level-card',
                mods: {
                    type: type
                },
                link: {
                    prefix: newsPage,
                    slug: item.link,
                    url: item.url,
                    text: item.text,
                    fontSize: item.fontSize,
                    image: item.image,
                    imageType: item.imageType
                },
                date: item.date,
                commentsData: item.link && bh.lib.util.getCommentsCount(commentsCount, item.link)
            };
        });
    }

    bh.match('level_type_text', function (ctx, json) {
        var maxColumnCount = 3;
        var columns = json.level.columns
            .map(getColumnBemJson.bind(null, json.newsPage, json.commentsData))
            .slice(0, maxColumnCount);

        ctx.content([
            {
                elem: 'content',
                elemMods: { type: 'text' },
                columns: columns
            },
            ctx.content()
        ], true);
    });
};
