module.exports = function (bh) {
    bh.match('level_type_text2', function (ctx, json) {
        var level = json.level;
        var textTitle = level.textTitle;
        var url = level.url;
        var goalId = level.metrikaGoalId;

        ctx
            .js(goalId ? { goalId: goalId } : null)
            .content([
                ctx.content(),
                {
                    elem: 'left',
                    imageUrl: level.imageUrl,
                    textTitle: textTitle,
                    themeLink: level.themeLink,
                    url: url,
                    imageType: level.imageType
                },
                {
                    elem: 'right',
                    enableButton: level.enableButton,
                    themeLink: level.themeLink,
                    textTitle: textTitle,
                    buttonText: level.buttonText,
                    text: level.text,
                    url: url
                }
            ], true);
    });

    bh.match('level__left', function (ctx, json) {
        ctx
            .tag('a')
            .attrs({ href: json.url })
            .mods({ type: json.imageType })
            .content([
                ctx.content(),
                {
                    elem: 'image-wrapper',
                    content: {
                        elem: 'img',
                        imageUrl: json.imageUrl,
                        imageType: json.imageType,
                        textTitle: json.textTitle
                    }
                }
            ], true);
    });

    bh.match('level__right', function (ctx, json) {
        var url = json.url;

        ctx.content([
            ctx.content(),
            {
                tag: 'a',
                attrs: { href: url },
                elem: 'title',
                content: json.textTitle
            },
            {
                elem: 'text',
                mix: { block: 'html-content' },
                content: json.text
            },
            json.enableButton && {
                elem: 'button',
                mods: { level: 'text2' },
                url: url,
                text: json.buttonText,
                width: bh.lib.global.isMobile && 'max'
            }
        ], true);
    });

    bh.match('level__img', function (ctx, json) {
        var textTitle = json.textTitle;

        ctx
            .tag('img')
            .attrs({
                title: textTitle,
                alt: textTitle
            });
    });

    bh.match('level__theme', function (ctx, json) {
        var themeLink = json.themeLink;
        var url = themeLink && themeLink.url;
        var text = themeLink.text;

        ctx.content([
            url ? {
                block: 'link',
                mods: { theme: 'level-no-arrow' },
                theme: 'normal',
                url: url,
                content: text
            } : text
        ]);
    });

    bh.match('level__button_level_text2', function (ctx, json) {
        var text = json.text || bh.lib.i18n('products', 'more.button');

        ctx.content([
            {
                block: 'button2',
                mods: {
                    type: 'link',
                    theme: 'normal',
                    size: 'm',
                    width: json.width || null
                },
                text: text,
                url: json.url
            }
        ]);
    });
};
