module.exports = function (bh) {
    'use strict';

    /**
     * Возвращает bem-json для переданного элемента этажа
     * @param {Object} item
     * @returns {Object}
     */
    function buildItem(item) {
        var data = prepareVideoData(item);

        return {

            block: 'level-card',
            mods: {
                type: 'video',
                source: data.source
            },
            attrs: {
                'data-video': data.video,
                'data-info': data.info
            },
            link: {
                image: data.image,
                text: data.text,
                url: data.url
            },
            date: data.date
        };
    }

    /**
     * Возвращает
     * @param {Object} item
     * @returns {Object}
     */
    function prepareVideoData(item) {
        var commonData = {
            text: item.text,
            date: item.date,
            info: item.info
        };

        if (item.player === 'yavh') {
            return Object.assign(commonData, {
                image: item.vhPreview,
                video: item.vhUrl,
                url: item.vhUrl,
                source: 'vh'
            });
        }

        return Object.assign(commonData, {
            image: item.thumbnail,
            video: item.video,
            url: item.url,
            source: 'youtube'
        });
    }


    bh.match('level_type_video', function (ctx, json) {
        var items = json.level.items.map(function (item) {
            item.url = bh.lib.util.placeholder(
                'https://www.youtube.com/watch?v={s}',
                item.identity
            );
            item.thumbnail = bh.lib.util.placeholder(
                'https://img.youtube.com/vi/{s}/hqdefault.jpg',
                item.identity
            );
            item.video = bh.lib.util.placeholder(
                'https://www.youtube-nocookie.com/embed/{s}?rel=0&amp;showinfo=0',
                item.identity
            );

            return item;
        });

        var isCarousel = items.length > 3 && !bh.lib.global.isMobile;

        ctx.content([
            isCarousel ? {
                elem: 'carousel-wrapper',
                content: {
                    block: 'owl-carousel',
                    mods: { type: 'arrows' },
                    js: {
                        options: {
                            responsive: false,
                            rewind: false,
                            nav: true,
                            loop: false
                        }
                    },
                    content: items.map(buildItem)
                }
            } : {
                elem: 'content',
                elemMods: { type: 'video' },
                columns: items.map(buildItem)
            },
            ctx.content()
        ], true);
    });
};
