module.exports = function (bh) {

    /**
     * Возвращает
     * @param {Object} item
     * @returns {Object}
     */
    function prepareVideoData(item) {
        var commonData = {
            text: item.text,
            date: item.date,
            info: item.info
        };

        if (item.player === 'yavh') {
            return Object.assign(commonData, {
                image: item.vhPreview,
                video: item.vhUrl,
                url: item.vhUrl,
                source: 'vh'
            });
        }

        return Object.assign(commonData, {
            image: bh.lib.util.placeholder(
                'https://img.youtube.com/vi/{s}/hqdefault.jpg',
                item.youtubeId
            ),
            video: bh.lib.util.placeholder(
                'https://www.youtube-nocookie.com/embed/{s}?rel=0&amp;showinfo=0',
                item.youtubeId
            ),
            url: bh.lib.util.placeholder(
                'https://www.youtube.com/watch?v={s}',
                item.youtubeId
            ),
            source: 'youtube'
        });
    }

    bh.match('level_type_video2', function (ctx, json) {
        var level = json.level;
        var textTitle = level.textTitle;
        var goalId = level.metrikaGoalId;
        var themeLink = level.themeLink;

        ctx
            .js(goalId ? { goalId: goalId } : null)
            .content([
                ctx.content(),
                {
                    elem: 'left-column',
                    player: level.player,
                    vhPreview: level.vhPreview,
                    vhUrl: level.vhUrl,
                    youtubeId: level.youtubeId
                },
                {
                    elem: 'right-column',
                    textTitle: textTitle,
                    text: level.text,
                    themeLink: themeLink,
                    player: level.player,
                    vhUrl: level.vhUrl,
                    youtubeId: level.youtubeId
                }
            ], true);
    });

    bh.match('level__left-column', function (ctx, json) {
        var data = prepareVideoData(json);

        ctx
            .content({
                block: 'level-card',
                mods: {
                    type: 'video',
                    mod: 'full',
                    source: data.source
                },
                attrs: {
                    'data-video': data.video,
                    'data-info': data.info
                },
                link: {
                    image: data.image,
                    text: data.text,
                    url: data.url
                },
                date: data.date
            });
    });

    bh.match('level__right-column', function (ctx, json) {
        var data = prepareVideoData(json);

        ctx.content([
            ctx.content(),
            json.themeLink && {
                elem: 'theme',
                themeLink: json.themeLink
            },
            {
                tag: 'a',
                elem: 'title',
                content: json.textTitle,
                attrs: {
                    href: data.url
                }
            },
            {
                elem: 'text',
                mix: { block: 'html-content' },
                content: json.text
            }
        ], true);
    });
};
