module.exports = function (bh) {
    'use strict';
    bh.match('level', function (ctx, json) {
        ctx
            .tag('section')
            .tParam('link', json.level.link)
            .content([
                {
                    elem: 'head',
                    level: json.level
                },
                ctx.content()
            ], true);
    });

    bh.match('level__head', function (ctx, json) {
        var subtitle = json.level.subtitle;

        ctx.content([
            {
                elem: 'head-title',
                content: json.level.title
            },
            subtitle && {
                elem: 'head-subtitle',
                content: subtitle
            },
            ctx.content()
        ], true);
    });

    bh.match('level__head-title', function (ctx) {
        ctx.tag('h3');
    });

    bh.match('level__head-subtitle', function (ctx) {
        ctx.tag('p');
    });

    bh.match('level__link-button', function (ctx) {
        var link = ctx.tParam('link');

        if (!(link && link.url && link.text)) {
            return '';
        }

        ctx.content({
            block: 'link',
            mods: { theme: 'level' },
            url: link.url,
            text: link.text
        });
    });
};
