module.exports = function (blocks) {
    'use strict';
    /* eslint-disable complexity */
    blocks.declare('levels', function (data) {
        var levelsWithComments = ['news', 'text', 'journal'];
        var levels = data.levels;
        var uatraits = data.uatraits || {};

        if (!levels && !data.shareLevel && !data.dashboard) {
            return;
        }

        return {
            block: 'levels',
            mods: {
                type: data.levelsType
            },
            content: {
                elem: 'content',
                content: [
                    data.levelsTitle && {
                        elem: 'title',
                        tag: 'h2',
                        content: data.levelsTitle
                    },
                    data.levelsText && {
                        elem: 'text',
                        content: data.levelsText
                    },
                    data.dashboard && data.dashboard.categories.length !== 0 && {
                        block: 'dashboard',
                        help: data.settings.dashboardHelp,
                        widgetParams: data.widgetParams,
                        dashboard: data.dashboard
                    },
                    levels && levels.length ? levels.map(function (level) {
                        const commentsData = levelsWithComments.indexOf(level.type) > -1 &&
                            data.commentsData;

                        return {
                            block: 'level',
                            newsPage: data.newsPage,
                            eduPage: data.eduPageUrl,
                            journalsPage: data.journalsPage,
                            mods: { type: level.type, color: level.backgroundColor },
                            level: level,
                            page: data.page,
                            commentsData: commentsData,
                            eventsData: data.eventsData,
                            services: data.services,
                            transactionPath: data.transactionPath,
                            url: data.url,
                            browserName: uatraits.BrowserName,
                            isBrowserValid: data.isBrowserValid,
                            comdiUrl: data.comdiUrl
                        };
                    }) : null,
                    data.shareLevel && blocks.exec('level-subscribe', data)
                ]
            }
        };
    });
    /* eslint-enable complexity */
};
