module.exports = function (bh) {
    /* eslint-disable complexity */
    bh.match('main-layout', function (ctx, json) {
        var title = json.title;
        var pageTitle = json.pageTitle;
        var section = json.section;
        var warningMessageKey = json.warningMessageKey;

        if (section) {
            title = bh.lib.i18n('sections', section);
        }

        ctx
            .tag('section')
            .content(warningMessageKey ? {
                elem: 'warning',
                content: bh.lib.i18n('common', warningMessageKey)
            } : {
                elem: 'column',
                content: [
                    pageTitle && !title && {
                        block: 'page-title',
                        mods: { align: 'center' },
                        section: pageTitle
                    },
                    title && !pageTitle && {
                        elem: 'title',
                        tag: 'h1',
                        content: title
                    },
                    {
                        elem: 'content',
                        mods: {
                            background: json.transparent && 'transparent'
                        },
                        left: json.left,
                        right: json.right,
                        middle: ctx.content(),
                        topContent: json.topContent
                    },
                    json.tail
                ]
            }, true);
    });
    /* eslint-enable complexity */

    bh.match('main-layout__content', function (ctx, json) {
        var left = json.left;
        var right = json.right;
        var middle = json.middle;

        ctx.content([
            left && {
                elem: 'left',
                data: left
            },
            right && {
                elem: 'right',
                data: right
            },
            middle && {
                elem: 'middle',
                data: middle
            }
        ]);
    });

    bh.match('main-layout__right', function (ctx, json) {
        ctx
            .tag('article')
            .content(json.data);
    });

    bh.match('main-layout__middle', function (ctx, json) {
        ctx
            .tag('article')
            .content(json.data);
    });
};
