module.exports = function (bh) {
    var getBreadcrumbsItem = function (item, indexChain) {
        var nestingPosition = (indexChain || '').length === 0 ? 0 : indexChain.split('.').length;

        return {
            block: 'main-menu',
            elem: 'breadcrumbs-item',
            content: [
                item.title,
                {
                    tag: 'meta',
                    attrs: {
                        itemprop: 'position',
                        content: nestingPosition
                    }
                },
                {
                    tag: 'meta',
                    attrs: {
                        itemprop: 'name',
                        content: item.title
                    }
                },
                {
                    tag: 'meta',
                    attrs: {
                        itemprop: 'item',
                        content: item.url
                    }
                }
            ],
            attrs: {
                'data-chain': indexChain,
                itemprop: 'itemListElement',
                itemscope: true,
                itemtype: 'http://schema.org/ListItem'
            }
        };
    };

    var getAdditionalBreadcrumbsItem = function (item) {
        return {
            block: 'main-menu',
            elem: 'breadcrumbs-item',
            content: item.text,
            attrs: {
                'data-url': item.url
            }
        };
    };

    /* eslint-disable complexity */
    bh.match('main-menu__breadcrumbs', function (ctx, json) {
        var currentItem = json.menu;
        var indexs = json.chain;
        var shouldAddBreadcrumbs = json.shouldAddBreadcrumbs;
        var items = currentItem.additionalBreadcrumbs;

        var content = [getBreadcrumbsItem(currentItem, '')];

        for (var i = 0; i < indexs.length; i += 1) {
            if (currentItem.items && currentItem.items.length > 0) {
                currentItem = currentItem.items[indexs[i]];
            }

            content.push(getBreadcrumbsItem(currentItem, indexs.slice(0, i + 1).join('.')));
        }

        if (shouldAddBreadcrumbs && items) {
            content = content.concat(items.map(function (item) {
                return getAdditionalBreadcrumbsItem(item);
            }));
        }

        ctx
            .attrs({
                itemscope: true,
                itemtype: 'http://schema.org/BreadcrumbList'
            })
            .content(content);
    });
};
