BEM.DOM.decl('map', {
    onSetMod: {
        js: function () {
            this._address = this.params.address;
            this._mapWrapper = this.domElem[0];
            this._map = null;

            this.init();
        }
    },

    init: function () {
        ymaps.ready(this._yaMapsInit.bind(this));
    },

    _yaMapsInit: function () {
        var address = this._address;
        var providerIsYandex = this._address.provider === 'yandex';

        this._map = new ymaps.Map(this._mapWrapper, {
            center: [address.latitude, address.longitude],
            zoom: address.zoom || 15,
            controls: ['zoomControl'],
            type: providerIsYandex ? 'yandex#map' : null
        });

        var point = new ymaps.Placemark(
            [address.latitude, address.longitude], {}, {
                preset: 'islands#redDotIcon'
            }
        );

        this._map.geoObjects.add(point);

        if (providerIsYandex) {
            return;
        }

        var osmLayer = new ymaps.Layer('https://a.tile.openstreetmap.org/%z/%x/%y.png', {
            projection: ymaps.projection.sphericalMercator,
            tileTransparent: true
        });

        this._map.layers.add(osmLayer);
    }
});
