module.exports = function (bh) {
    bh.match('material-card', function (ctx, json) {
        var data = json.item;
        var titleImage = data.titleImage;
        var isTouch = bh.lib.global.isTouch;
        var categories = [];

        if (titleImage) {
            ctx.mod('image', 'yes');
        }

        if (data.categories) {
            categories = data.categories.map(function (category) {
                if (category.parentCategoryId) {
                    return {
                        block: 'link',
                        url: category.url,
                        content: {
                            block: 'material-card',
                            elem: 'category',
                            content: category.displayName
                        }
                    };
                }
            });
        }

        ctx.content([
            isTouch && Boolean(categories.length) && categories,
            titleImage && {
                elem: 'image-wrap',
                content: {
                    block: 'link',
                    mods: { theme: 'normal' },
                    url: data.url,
                    content: {
                        block: 'material-card',
                        elem: 'image',
                        content: {
                            tag: 'img',
                            attrs: { src: titleImage.w444.fullPath }
                        }
                    }
                }
            },
            {
                elem: 'content',
                content: [
                    !isTouch && Boolean(categories.length) && categories,
                    {
                        block: 'link',
                        mods: { theme: 'normal' },
                        url: data.url,
                        content: [
                            {
                                block: 'material-card',
                                elem: 'header',
                                content: data.approvedTitle
                            }
                        ]
                    },
                    data.approvedPreview && !isTouch && !titleImage && {
                        elem: 'description',
                        mix: { block: 'html-content' },
                        content: data.approvedPreview
                    },
                    {
                        elem: 'meta',
                        content: [
                            !data.isDatesHidden && {
                                elem: 'date',
                                tag: 'span',
                                content: bh.lib.util.date.humanizeDate(data.date, 'full')
                            },
                            data.commentsCount ? {
                                block: 'comments-count',
                                tag: 'span',
                                commentsData: data.commentsCount
                            } : null,
                            data.hasHotMark && {
                                block: 'icon',
                                mods: { type: 'hot-mark' }
                            }
                        ]
                    }
                ]
            }
        ]);
    });
};
