module.exports = function (bh) {
    bh.match('materials-header', function (ctx, json) {
        ctx
            .tag('section')
            .content([
                {
                    elem: 'title',
                    content: json.title
                },
                json.description && {
                    elem: 'description',
                    mix: { block: 'html-content' },
                    content: json.description
                },
                {
                    block: 'filters',
                    items: json.filters,
                    searchUrl: json.searchUrl,
                    mods: { theme: 'journals' },
                    size: 'm'
                }
            ]);
    });

    bh.match('materials-header__title', function (ctx) {
        ctx.tag('h1');
    });
};
