module.exports = function (bh) {
    bh.match('materials-list', function (ctx, json) {
        var materials = json.materials;

        var content = materials.length ?
            [
                {
                    elem: 'content',
                    content: materials.map(function (item) {
                        return {
                            block: 'material-card',
                            item: item
                        };
                    })
                },
                { block: 'notifications-list' },
                {
                    elem: 'gap',
                    mods: { disabled: 'yes' }
                }
            ] :
            {
                elem: 'no-materials',
                content: json.noMaterials
            };

        ctx
            .js({
                more: json.more,
                filterUrl: json.filterUrl,
                materialsCount: materials.length,
                lastPostId: json.lastPostId,
                lastCaseSlug: json.lastCaseSlug,
                categoryId: json.categoryId
            })
            .content(content);
    });

    bh.match('materials-list__cover', function (ctx) {
        ctx.content({
            block: 'spin2',
            mods: {
                size: 'l',
                progress: 'yes'
            }
        });
    });
};
