BEM.DOM.decl('materials-list', {
    onSetMod: {
        js: {
            inited: function () {
                this._initialize();

                this.materialsCount = this.params.materialsCount;
                this.lastPostId = this.params.lastPostId;
                this.lastCaseSlug = this.params.lastCaseSlug;
                this.more = this.params.more;
                this.categoryId = this.params.categoryId;

                if (this.materialsCount) {
                    this.bindToWin('scroll', this._onScroll.bind(this));
                }
            }
        }
    },

    /**
     * Инициализация блока
     * @private
     */
    _initialize: function () {
        this.__self.list = this;
        this.content = this.findElem('content');
        this._gap = this.findElem('gap');
        this._chunkLength = 8;
        this._isServerFree = true;
        this._lockSpinnerMore = false;
    },

    /**
     * Добавляет переданные материалы в список
     * @param {Object []} materials
     * @private
     */
    _appendMaterials: function (materials) {
        var materialsBlocks = materials
            .reduce(function (current, material) {
                return current + BH.apply({
                    block: 'material-card',
                    item: material
                });
            }, '');

        BEM.DOM.append(this.content, materialsBlocks);

        this.materialsCount += materials.length;
    },

    /**
     * Удаляет все решения из списка
     * @private
     */
    _destructSolutions: function () {
        this.content.text('');
        this.solutionsCount = 0;
    },

    /**
     * Обработчик скролла
     * @private
     */
    _onScroll: function () {
        var windowOffset = window.pageYOffset + window.innerHeight;
        var contentOffset = this.content.offset().top + this.content.height();

        if (this.more && windowOffset > contentOffset) {
            this._runSpinnerMore();
            this._loadMaterialsChunk();
        }
    },

    /**
     * Загружает с сервера материалы
     * @private
     */
    _loadMaterialsChunk: function () {
        if (!this._isServerFree) {
            return;
        }

        this._isServerFree = false;

        var data = {};
        var materialsBlock = this.findBlockOutside('materials');
        var filters = materialsBlock.findBlockInside('filters');

        if (filters) {
            data = filters.accumulateFilters();
        }

        if (this.categoryId) {
            data.categoryId = this.categoryId;
        }

        data.lastPostId = this.lastPostId;
        data.lastCaseSlug = this.lastCaseSlug;

        var requestOptions = {
            type: 'POST',
            url: this.params.filterUrl,
            contentType: 'application/json',
            data: JSON.stringify(data)
        };

        $.ajax(requestOptions)
            .done(this._addMaterials.bind(this))
            .fail(this._showErrorMessage.bind(this));
    },

    /**
     * Показывает спиннер при подгрузке новых решений
     */
    _runSpinnerMore: function () {
        if (this._lockSpinnerMore) {
            return;
        }

        this._lockSpinnerMore = true;

        this.delMod(this._gap, 'disabled');

        var spinner = BH.apply({
            block: 'materials-list',
            elem: 'cover',
            mods: { type: 'more' }
        });

        this._spinnerMore = $(spinner);

        BEM.DOM.append(this._gap, this._spinnerMore);
    },

    /**
     * Скрывает спиннер для подгрузки новых решений
     * @private
     */
    _hideSpinnerMore: function () {
        if (!this._spinnerMore) {
            return;
        }

        this._lockSpinnerMore = false;

        this.setMod(this._gap, 'disabled', 'yes');

        BEM.DOM.destruct(this._spinnerMore);
    },

    /**
     * Обработчик ответа сервера
     * @param {Object} data
     * @returns {null}
     * @private
     */
    _addMaterials: function (data) {
        this._isServerFree = true;

        if (!data.posts || !Array.isArray(data.posts)) {
            return this._showErrorMessage();
        }

        this.more = data.more;
        this.lastPostId = data.lastPostId;
        this.lastCaseSlug = data.lastCaseSlug;

        this._appendMaterials(data.posts);
        this._hideSpinnerMore();
    },

    /**
     * Показывает сообщение об ошибке
     * @private
     */
    _showErrorMessage: function () {
        this._isServerFree = true;
        this._hideSpinnerMore();

        var failMessage = BH.lib.i18n('materials', 'error');

        BEM.blocks['notifications-list'].notify(failMessage);
    }
}, {

    /**
     * Показывает спиннер
     */
    runSpinner: function () {
        var spinner = BH.apply({
            block: 'materials-list',
            elem: 'cover',
            mods: {
                type: 'more'
            }
        });

        this.list.spinner = $(spinner);

        BEM.DOM.append(this.list.content, this.list.spinner);
    },

    /**
     * Скрывает спиннер
     */
    hideSpinner: function () {
        if (this.list.spinner) {
            BEM.DOM.destruct(this.list.spinner);
        }
    }
});
