module.exports = function (bh) {
    bh.match('media', function (ctx) {
        ctx
            .tag('section')
            .js(true)
            .content({
                elem: 'wrapper',
                content: ctx.content()
            }, true);
    });

    bh.match('media__header', function (ctx) {
        var media = ctx.param('media');
        var defaultTab = ctx.param('defaultTab');

        ctx.content({
            block: 'radio-button',
            js: { id: 'media-block' },
            mods: { size: 'm', theme: 'normal' },
            name: 'media-block',
            value: defaultTab,
            content: Object.keys(media).filter(function (key) {
                return media[key].length;
            })
                .map(function (key) {
                    return {
                        elem: 'radio',
                        controlAttrs: { value: key },
                        content: bh.lib.i18n('common', 'media.' + key)
                    };
                })
        });
    });

    bh.match('media__data', function (ctx) {
        var media = ctx.param('media');

        var framesets = Object.keys(media).map(function (key) {
            return {
                elem: 'frameset',
                mods: { type: key },
                mix: { block: 'clearfix' },
                frames: media[key],
                isCurrent: key === ctx.param('defaultTab')
            };
        });

        ctx.content(framesets);
    });

    bh.match('media__frameset', function (ctx) {
        var frames = ctx.param('frames');

        if (!frames.length) {
            return '';
        }

        ctx.mod('hidden', ctx.param('isCurrent') ? '' : 'yes');

        ctx.content(frames.map(function (frame) {
            return {
                elem: 'frame',
                frame: frame
            };
        }));
    });

    bh.match('media__frame', function (ctx) {
        var frame = ctx.param('frame');

        ctx.content([
            {
                elem: 'image',
                src: bh.lib.util.mds(frame.image, 'w310')
            },
            {
                elem: 'type',
                content: frame.type
            },
            {
                elem: 'link',
                content: frame.text,
                url: frame.link
            }
        ]);
    });

    bh.match('media__image', function (ctx) {
        ctx.content({
            tag: 'img',
            attrs: {
                src: ctx.param('src')
            }
        });
    });

    bh.match('media__link', function (ctx) {
        ctx
            .tag('a')
            .attr('href', ctx.param('url'));
    });
};
