BEM.DOM.decl('media', {
    onSetMod: {
        js: {
            inited: function () {
                this._findFramesets();
                this._bindEvents();
            }
        }
    },

    _findFramesets: function () {
        this._framesets = this.elem('frameset');
    },

    _bindEvents: function () {
        this._radioButton = this.findBlockInside('radio-button');
        this._radioButton.on('change', function () {
            var val = this._radioButton.val();

            this._toggleTabs(val);
        }.bind(this));
        this.bindTo(this.elem('link'), 'pointerclick', this._onLinkClick);
    },

    _toggleTabs: function (type) {
        this._framesets.each(function (index, item) {
            var isCurrent = this.hasMod($(item), 'type', type);

            this.toggleMod($(item), 'hidden', '', 'yes', isCurrent);
        }.bind(this));
    },

    _onLinkClick: function () {
        BEM.blocks.metrika.reachGoal('media_block_click');
    }
});
