module.exports = function (blocks) {
    var defaultTab = 'cases';

    blocks.declare('media', function (data) {
        var blockExists = data.media ? Object.keys(data.media).some(function (key) {
            return data.media[key].length;
        }) : false;

        if (!blockExists) {
            return;
        }

        if (data.media[defaultTab].length === 0) {
            defaultTab = Object.keys(data.media).filter(function (key) {
                return data.media[key].length > 0;
            })[0];
        }

        return {
            block: 'media',
            content: [
                {
                    elem: 'header',
                    media: data.media,
                    defaultTab: defaultTab
                },
                {
                    elem: 'data',
                    media: data.media,
                    defaultTab: defaultTab
                }
            ]
        };
    });
};
