module.exports = function (bh) {
    bh.match('metrika', function (ctx, json) {
        var counters = json.metrikaCounters;

        if (!(Array.isArray(counters) && counters.length)) {
            return '';
        }

        ctx
            .js({
                counters: counters.map(function (counter) {
                    return counter.id;
                })
            })
            .tag('section')
            .content(counters.map( function(counter) {
                return {
                    elem: 'counter',
                    counter: counter
                };
            }));
    });

    bh.match('metrika__counter', function (ctx, json) {
        var counter = json.counter;
        var params = Object.keys(counter.params)
            .map( function(key) {
                return key + ':' + String(counter.params[key]);
            })
            .join(',');

        var initScript = '(function(m,e,t,r,i,k,a)' +
            '{m[i]=m[i]||function(){(m[i].a=m[i].a||[]).push(arguments)};' +
            'm[i].l=1*new Date();k=e.createElement(t),a=e.getElementsByTagName(t)[0]' +
            ',k.async=1,k.src=r,a.parentNode.insertBefore(k,a)})' +
            '(window, document, "script", "https://mc.yandex.ru/metrika/tag.js", "ym");' +
            'ym(' + counter.id + ', "init", {' + params + '});';

        ctx
            .tag('i')
            .content([
                {
                    tag: 'script',
                    attrs: { nonce: bh.lib.global.nonce },
                    type: 'text/javascript',
                    content: initScript
                },
                {
                    tag: 'noscript',
                    content: {
                        tag: 'div',
                        content: {
                            tag: 'img',
                            attrs: {
                                src: 'https://mc.yandex.ru/watch/' + counter.id,
                                style: 'position:absolute; left:-9999px;',
                                alt: ''
                            }
                        }
                    }
                }
            ]);
    });
};
