BEM.DOM.decl('metrika', {
    onSetMod: {
        js: {
            inited: function () {
                this._attempts = {};
                this.__self._counters = [];
                this.params.counters.forEach(function (counterId) {
                    this._attempts[counterId] = 100;
                    this._discoverMetrika(counterId);
                }, this);
            }
        }
    },

    _discoverMetrika: function (counterId) {
        /* eslint-disable no-unused-expressions */
        var counter = window['yaCounter' + counterId];

        this._attempts[counterId] = this._attempts[counterId] - 1;

        if (counter) {
            this.__self._counters.push(counter);

            if (this.__self._pendingGoals && this.__self._pendingGoals.length) {
                this._reachPendingGoals();
            }
        } else if (this._attempts[counterId] > 0) {
            setTimeout(this._discoverMetrika.bind(this, counterId), 1000);
        }
    },

    _reachPendingGoals: function () {
        do {
            this.__self.reachGoal(this.__self._pendingGoals.pop());
        } while (this.__self._pendingGoals.length);
    }
}, {
    reachGoal: function (goal, params) {
        params = params || {};

        params.URL = document.location.href;

        if (this._counters && this._counters.length > 0) {
            this._counters.forEach(function (counter) {
                counter.reachGoal(goal, params);
            });
        } else {
            this._pendingGoals = this._pendingGoals || [];
            this._pendingGoals.push(goal);
        }
    }
});
