module.exports = function (blocks) {
    blocks.declare('metrika', function (data) {
        var metrikaCounters = data.metrikaCounters;
        var params = data.metrikaCountersParams || {};

        if (!metrikaCounters || metrikaCounters.length === 0) {
            return '';
        }

        return {
            block: 'metrika',
            metrikaCounters: metrikaCounters.map(function (counter) {
                return {
                    id: counter.id,
                    params: Object.assign({}, params, counter.params)
                };
            })
        };
    });
};
