BEM.DOM.decl({ block: 'modal', modName: 'type', modVal: 'dark' }, {
    onSetMod: {
        js: function () {
            'use strict';
            this.__base.apply(this, arguments);
            this._bPage = this.findBlockOutside('b-page');

            this.on('afterOpen', this._onAfterOpen, this);
            this.on('beforeOpen', this._onBeforeOpen, this);
            this.on('beforeClose', this._onBeforeClose, this);
        }
    },

    _onBeforeOpen: function() {
        this._bPage.setMod('modal', 'yes');
    },

    _onAfterOpen: function () {
        this.findElem('close').one('pointerclick', this._hideModal.bind(this));
    },

    _onBeforeClose: function () {
        this._bPage.setMod('modal', 'no');
    },

    _hideModal: function () {
        this.delMod('visible');
    }
});
