module.exports = function (bh) {
    bh.match('news-author', function (ctx, json) {
        var data = json.data;
        var name = data[0];
        var description = data[1];
        var url = data[2];

        ctx.content([
            {
                elem: 'image',
                content: {
                    tag: 'img',
                    attrs: {
                        src: url,
                        alt: name
                    }
                }
            },
            {
                elem: 'info',
                content: [
                    {
                        elem: 'name',
                        content: name
                    },
                    {
                        elem: 'description',
                        content: description
                    }
                ]
            }
        ]);
    });
};
