module.exports = function (bh) {
    /* eslint-disable complexity */
    bh.match('news-filter', function (ctx) {
        var data = ctx.param('data');
        var blog = data.blog;
        var tags = data.tags;
        var selectedTag = data.tag;

        if (!data.posts && !data.post || !tags) {
            return '';
        }
        ctx
            .js({
                mainPage: data.currentPath
            })
            .content([
                blog && {
                    elem: 'calendar',
                    content: {
                        block: 'calendar',
                        blog: blog,
                        currentPath: data.currentPath
                    }
                },
                {
                    elem: 'select',
                    content: {
                        block: 'select',
                        name: 'init',
                        mods: {
                            type: 'tags',
                            size: 'm',
                            theme: 'normal',
                            layout: 'content',
                            width: 'available'
                        },
                        js: { rows: 12 },
                        content: [
                            {
                                block: 'button',
                                mods: { theme: 'normal' },
                                content: selectedTag ?
                                    selectedTag.displayName : bh.lib.i18n('news', 'tags')
                            },
                            {
                                elem: 'control',
                                content: [
                                    {
                                        elem: 'option',
                                        attrs: { value: 'all' },
                                        content: bh.lib.i18n('news', 'tags')
                                    },
                                    tags.map(function (tag) {
                                        var slug = selectedTag && selectedTag.slug;

                                        return {
                                            elem: 'option',
                                            attrs: {
                                                value: tag.url,
                                                selected: slug === tag.slug ? 'selected' : false
                                            },
                                            content: tag.displayName
                                        };
                                    })
                                ]
                            }
                        ]
                    }
                },
                (data.dateFilterEnabled || data.tagFilterEnabled) && {
                    elem: 'clear',
                    content: {
                        block: 'link',
                        mods: { theme: 'pseudo' },
                        url: data.blog.blogUrl,
                        text: bh.lib.i18n('news', 'filters.clear')
                    }
                }
            ]);
    });
    /* eslint-enable complexity */
};
