module.exports = function (bh) {
    bh.match('news-header', function (ctx) {
        var data = ctx.param('data');
        var title = data.title;
        var description = data.description;

        if (!title && !description) {
            return '';
        }
        ctx
            .content([
                title && {
                    tag: 'h2',
                    elem: 'title',
                    content: title
                },
                description && {
                    tag: 'div',
                    elem: 'text',
                    content: description,
                    mix: { block: 'html-content' }
                }
            ]);
    });
};
