module.exports = function (bh) {
    /* eslint-disable complexity */
    bh.match('news-info', function (ctx, json) {
        var data = json.data;
        var posts = data.posts;
        var blog = data.blog;
        var post = data.post;
        var isOutdated = post && post.isOutdated;

        if (!posts && !post || !blog) {
            return '';
        }

        ctx.mix({ block: 'clearfix' });

        if (post) {
            var commentsEnabled = post.commentsData.isPostInited &&
                !post.commentsData.isReadonlyComments &&
                blog.canComment &&
                post.commentsEnabled;

            ctx
                .js({
                    hasRelatedArticles: blog.hasRelatedArticles,
                    relatedArticlesUrl: post.relatedArticlesUrl,
                    relatedTitle: post.relatedTitle,
                    scrollMetrics: json.scrollMetrics
                })
                .mods({ type: 'post' })
                .content([
                    isOutdated && {
                        elem: 'outdated-message'
                    },
                    post && {
                        elem: 'post',
                        post: post,
                        blogUrl: blog.blogUrl,
                        isEduPost: data.section === 'edu',
                        isPlainPost: data.isPlainPost,
                        og: data.og,
                        nav: {
                            back: data.backLink,
                            nextLesson: data.nextLesson
                        }
                    },
                    commentsEnabled && {
                        block: 'ya-cmnt',
                        commentsData: post.commentsData,
                        reactScript: data.reactScript
                    },
                    data.articleCta && {
                        elem: 'cta',
                        content: {
                            block: 'product-cta-3',
                            data: Object.assign({}, data.articleCta, {
                                color: 'gray'
                            })
                        }
                    },
                    blog.hasRelatedArticles && { elem: 'related' },
                    { block: 'notifications-list' }
                ]);
        }
    });

    bh.match('news-info__outdated-message', function (ctx) {

        ctx.content([
            {
                block: 'logo-outdated-message'
            },
            {
                elem: 'text',
                content: [
                    {
                        block: 'title',
                        content: [bh.lib.i18n('news', 'outdated_news.title')]
                    },
                    {
                        block: 'description',
                        content: [bh.lib.i18n('news', 'outdated_news.description')]
                    }
                ]
            }
        ]);
    });

    bh.match('news-info__post', function (ctx, json) {
        /* eslint-disable no-unused-expressions */
        var post = json.post;
        var nav = json.nav;
        var isEduPost = json.isEduPost;
        var isPlainPost = json.isPlainPost;

        if (!post || !post.approvedBody) {
            return;
        }

        isEduPost && ctx.mod('type', 'edu');
        isPlainPost && ctx.mod('type', 'plain');

        ctx
            .attrs({
                itemscope: true,
                itemtype: 'http://schema.org/NewsArticle'
            })
            .content([
                {
                    tag: 'meta',
                    attrs: {
                        itemprop: 'identifier',
                        content: post.slug
                    }
                },
                {
                    elem: 'post-title',
                    content: [
                        isPlainPost && post.titleImage && post.viewType !== 'tumb' && {
                            elem: 'post-image-wrap',
                            content: [
                                {
                                    block: 'post-image',
                                    titleImage: post.titleImage
                                }
                            ]
                        },
                        {
                            elem: 'title',
                            content: post.approvedTitle,
                            attrs: {
                                itemprop: 'headline'
                            }
                        },
                        {
                            elem: 'published-date',
                            tag: 'time',
                            content: bh.lib.util.date.humanizeDate(post.date, 'full'),
                            attrs: {
                                datetime: post.publishDate,
                                itemprop: 'datePublished'
                            }
                        },
                        isPlainPost &&
                        post.viewType !== 'tumb' && post.approvedPreview && [
                            {
                                elem: 'post-preview',
                                mix: { block: 'test', force: true },
                                content: post.approvedPreview
                            },
                            {
                                block: 'test'
                            },
                            {
                                elem: 'hr'
                            }
                        ],
                        {
                            tag: 'meta',
                            attrs: {
                                itemprop: 'dateModified',
                                content: post.modificationDate
                            }
                        }
                    ]
                },
                isEduPost && {
                    elem: 'post-nav',
                    nav: nav
                },
                {
                    elem: 'post-body',
                    mix: [
                        { block: 'html-content' },
                        { block: 'page-content' }
                    ],
                    content: bh.lib.util.template(post.approvedBody.html),
                    attrs: {
                        itemprop: 'articleBody'
                    }
                },
                !isEduPost && post.tags && post.tags.length ? [
                    { elem: 'hr' },
                    {
                        elem: 'tags',
                        tags: post.tags,
                        baseUrl: json.blogUrl
                    }
                ] : null,
                isPlainPost && {
                    elem: 'social',
                    content: {
                        elem: 'share',
                        post: post,
                        og: json.og
                    }
                },
                isEduPost && {
                    elem: 'post-nav',
                    nav: nav
                },
                json.articleCta && {
                    elem: 'cta',
                    content: {
                        block: 'product-cta-3',
                        data: Object.assign({}, json.articleCta, {
                            color: 'gray'
                        })
                    }
                }
            ]);
    });
    /* eslint-enable complexity */

    bh.match('news-info__post-nav', function (ctx) {
        var nav = ctx.param('nav');
        var nextLesson = nav.nextLesson;

        ctx.content([
            {
                block: 'link',
                mods: { theme: 'normal' },
                content: '&larr; ' + bh.lib.i18n('news', 'edu.nav.list'),
                url: nav.back
            },
            nextLesson && [
                ' | ',
                {
                    block: 'link',
                    mods: { theme: 'normal' },
                    content: bh.lib.i18n('news', 'edu.nav.next') + ' &rarr;',
                    url: nextLesson
                }
            ]
        ]);
    });

    bh.match('news-info__hr', function (ctx) {
        ctx.tag('hr');
    });

    bh.match('news-info__tags', function (ctx, json) {
        if (!json.tags) {
            return '';
        }

        ctx
            .content(json.tags
                .filter(function (tag) {
                    return !tag.slug.startsWith('hidden-');
                })
                .map(function (tag) {
                    return [
                        {
                            tag: 'meta',
                            attrs: {
                                itemprop: 'about',
                                content: tag.displayName
                            }
                        },
                        {
                            block: 'link',
                            mix: {
                                block: 'news-info',
                                elem: 'tag'
                            },
                            mods: { theme: 'light-gray' },
                            url: json.baseUrl + '?tag=' + tag.slug,
                            text: '#' + tag.displayName
                        }
                    ];
                })
            );
    });

    bh.match('news-info__cut', function (ctx, json) {
        var data = json.data;
        var title = data[0];
        var text = data[1];

        ctx.content([
            {
                elem: 'cut-toggle',
                content: title
            },
            {
                elem: 'cut-text',
                mix: { block: 'html-content' },
                content: text
            }
        ]);
    });

    bh.match('news-info__cut-toggle', function (ctx) {
        ctx
            .tag('span')
            .content([
                ctx.content(),
                {
                    block: 'icon',
                    mods: {
                        type: 'arrow',
                        direction: 'bottom'
                    }
                }
            ], true);
    });

    bh.match('news-info__cut-text', function (ctx) {
        ctx.tag('p');
    });
};
