BEM.DOM.decl('news-info', {
    onSetMod: {
        js: function () {
            this._relatedArticlesUrl = this.params.relatedArticlesUrl;

            this._findElems();
            this._bindEvents();
            BEM.blocks['i-bem'].touchIframeFix(this);

            if (this.params.hasRelatedArticles) {
                this._loadRelatedArticles();
            }
        }
    },

    _findElems: function () {
        this._toggle = this.elem('cut-toggle');
        this._post = this.elem('post');
        this.findBlocksInside('yablogs-cut'); // нужно, чтобы на yablogs-cut заинитился js
    },

    _bindEvents: function () {
        /* eslint-disable no-unused-expressions */
        this._toggle.on('click', this._onToggle.bind(this));
        this._post.on('click', this._openYouTubeVideo.bind(this));
        this._middleScrollHandler = $.debounce(this._detectScrollMiddle.bind(this), 300);
        this._endScrollHandler = $.debounce(this._detectScrollEnd.bind(this), 300);

        if (this.params.scrollMetrics) {
            if (BH.lib.global.isMobile) {
                this.bindToWin('scroll', this._middleScrollHandler);
            }

            this.bindToWin('scroll', this._endScrollHandler);
        }
    },

    _onToggle: function (e) {
        var $elem = $(e.currentTarget);
        var icon = this.findBlockInside($elem, 'icon');

        this.toggleMod($elem, 'expanded', 'yes');
        icon.toggleMod('direction', 'bottom', 'top');
    },

    _detectScrollMiddle: function () {
        BEM.blocks['i-bem'].detectScrollMiddle
            .call(this, 'news_page_scroll_middle', this._middleScrollHandler);
    },

    _detectScrollEnd: function () {
        var post = this.elem('post');

        BEM.blocks['i-bem'].detectScrollEnd
            .call(this, post, 'news_page_scroll_end', this._endScrollHandler);
    },

    _openYouTubeVideo: function(e) {
        var targetPreviewImg = e.target.alt === 'youtube-img-preview' ? e.target : '';
        var targetParent = e.target.id === 'youtube-block' ? e.target.children[0] : '';
        var previewImg = targetPreviewImg || targetParent;

        if (previewImg) {
            previewImg.alt = 'img-preview-off';
            previewImg.parentNode.id = 'youtube-video-on';
            var div = document.createElement('div');

            div.className = 'youtube-wrapper';
            //  eslint-disable-next-line max-len
            div.innerHTML = '<iframe frameborder="0" allowfullscreen="1" allow="autoplay" class="f-youtube" src="https://www.youtube-nocookie.com/embed/' + previewImg.id + '?autoplay=1&mute=1"></iframe>';
            previewImg.after(div);
        }

    },

    _loadRelatedArticles: function () {
        var relatedTitle = this.params.relatedTitle;
        var relatedElem = this.findElem('related');

        $.ajax({
            url: this._relatedArticlesUrl,
            contentType: 'application/json'
        })
            .done(function (articles) {
                var related = {
                    block: 'related-articles',
                    items: articles,
                    title: relatedTitle
                };

                BEM.DOM.append(relatedElem, BH.apply(related));
            });
    }
});
