module.exports = function (bh) {
    bh.match('news-item_view_background', function (ctx) {
        var post = ctx.param('post');
        var date = new Date(post.date);
        var size = ctx.mod('size');

        ctx
            .tag('a')
            .attr('href', post.url)
            .content([
                {
                    elem: 'image',
                    src: bh.lib.util.mds(post.titleImage.orig.fullPath,
                        size === 'l' ? 'w260h360' : 'w260h260')
                },
                {
                    elem: 'info',
                    content: [
                        {
                            elem: 'title',
                            tag: 'h2',
                            content: post.approvedTitle
                        }
                    ]
                },
                post.tags.length > 0 && {
                    elem: 'tag',
                    tagObj: post.tags[0]
                },
                {
                    elem: 'date',
                    tag: 'time',
                    content: bh.lib.util.date.humanizeDate(date, 'short')
                }
            ]);
    });

    bh.match('news-item__image', function (ctx) {
        ctx
            .attr('src', ctx.param('src'))
            .tag('img');
    });
};
