module.exports = function (bh) {
    bh.match('news-item_view_digest', function (ctx) {
        var post = ctx.param('post');
        var date = new Date(post.date);

        ctx.content([
            {
                elem: 'info',
                content: [
                    {
                        elem: 'title',
                        content: post.approvedTitle
                    },
                    ctx.mod('size') === 'l' && {
                        elem: 'preview',
                        content: post.approvedPreview.html
                    }
                ]
            },
            {
                elem: 'date',
                content: date.getFullYear()
            }
        ]);
    });
};
