module.exports = function (bh) {
    bh.match('news-item_view_yellow', function (ctx) {
        var post = ctx.param('post');
        var date = new Date(post.date);

        ctx.content([
            {
                elem: 'info',
                content: [
                    {
                        elem: 'title',
                        content: post.approvedTitle
                    },
                    {
                        elem: 'preview',
                        content: post.approvedPreview.html
                    }
                ]
            },
            post.tags.length > 0 && {
                elem: 'tag',
                tagObj: post.tags[0]
            },
            {
                elem: 'date',
                content: bh.lib.util.date.humanizeDate(date, 'short')
            }
        ]);
    });
};
