module.exports = function (bh) {
    bh.match('news-list__item', function (ctx, json) {
        var post = json.post;
        var viewType = post.viewType;
        var isTumb = viewType === 'tumb';

        if (isTumb) {
            ctx.mod('tumb', 'yes');
        }

        ctx.content([
            {
                block: 'link',
                mods: { theme: 'normal' },
                url: post.url,
                mix: {
                    block: 'news-list',
                    elem: 'item-active'
                },
                content: [
                    post.titleImage && {
                        block: 'news-list',
                        elem: 'post-image-wrap',
                        content: [
                            {
                                block: 'post-image',
                                titleImage: post.titleImage,
                                viewType: viewType
                            }
                        ]
                    }
                ]
            },
            {
                elem: 'content',
                content: [
                    {
                        block: 'link',
                        mods: { theme: 'normal' },
                        url: post.url,
                        mix: {
                            block: 'news-list',
                            elem: 'item-active'
                        },
                        content: [
                            {
                                block: 'news-list',
                                elem: 'item-header',
                                content: post.approvedTitle
                            }
                        ]
                    },
                    !isTumb && post.approvedPreview && {
                        elem: 'item-description',
                        content: post.approvedPreview
                    },
                    {
                        elem: 'item-meta',
                        content: [
                            {
                                elem: 'item-date',
                                tag: 'span',
                                content: bh.lib.util.date.humanizeDate(post.date, 'full')
                            },
                            post.commentsCount ? {
                                block: 'comments-count',
                                tag: 'span',
                                commentsData: post.commentsCount
                            } : null,
                            post.hasHotMark && {
                                block: 'icon',
                                mods: { type: 'hot-mark' }
                            }
                        ]
                    }
                ]
            }
        ]);
    });
};
