module.exports = function (bh) {
    bh.match('news-list', function (ctx, json) {
        var data = json.data;
        var posts = data.posts;

        if (!posts || !posts.length) {
            return;
        }

        var lastPost = posts[posts.length - 1];

        ctx
            .mix({
                block: 'news-loader',
                js: {
                    blockName: 'news-list',
                    urlNext: lastPost.nextUrl
                }
            })
            .content([
                ctx.content(),
                {
                    elem: 'group',
                    posts: posts
                },
                lastPost.nextUrl && {
                    elem: 'more',
                    posts: posts
                }
            ], true);
    });

    bh.match('news-list__more', function (ctx) {
        ctx.content([
            {
                block: 'button2',
                mods: { theme: 'normal', size: 'l', width: 'max' },
                text: bh.lib.i18n('common', 'more.button.text')
            },
            {
                block: 'tooltip',
                mods: { size: 'm', theme: 'error' },
                content: bh.lib.i18n('common', 'more.button.error')
            }
        ]);
    });
};
