BEM.DOM.decl('news-loader', {
    onSetMod: {
        js: {
            inited: function () {
                this._newsList = this.findBlockOn(this.params.blockName);
                this._moreButton = this._newsList.findBlockInside('more', 'button2');

                if (!this._moreButton) {
                    return;
                }
                this._moreWrapper = this._newsList.elem('more');
                this._tooltip = this.findBlockInside('tooltip').setOwner(this._moreButton);
                this._url = this.params.urlNext;
                this._moreButton.on('click', this._onClickMore.bind(this));
            }
        }
    },

    /**
     * Обрабатывает клик по кнопке "Показать еще"
     * @private
     */
    _onClickMore: function () {
        this._switchMoreButton(true);

        $.ajax({ url: this._url })
            .done(this._onSuccess.bind(this))
            .fail(this._onError.bind(this));
    },

    /**
     * Обработчик ошибки получения новостей
     * @private
     */
    _onError: function () {
        this._switchMoreButton(false);
        this._tooltip.setMod('shown', 'yes');
    },

    /**
     * Обработчик успешного запроса за новостями
     * @param {Array} data
     * @private
     */
    _onSuccess: function (data) {
        this._tooltip.delMod('shown');
        var lastPost = data[data.length - 1];
        var groups = BH.apply({
            block: this.params.blockName,
            elem: 'group',
            posts: data
        });

        BEM.DOM.before(this._moreWrapper, groups, this);

        if (!lastPost.nextUrl) {
            BEM.DOM.destruct(this._moreWrapper);

            return;
        }

        this._url = lastPost.nextUrl;
        this._switchMoreButton(false);
    },

    /**
     * В зависимости от параметра блокирует или разблокирует кнопку
     * @param {Boolean} on
     * @private
     */
    _switchMoreButton: function (on) {
        if (on) {
            this._moreButton.setMod('disabled', 'yes');

            return;
        }
        this._moreButton.delMod('disabled');
    }
});
