module.exports = function (bh) {
    var makeDateValue = function (monthName, year) {
        return encodeURI('?year=' + year + '&month=' + monthName);
    };

    var prepareOption = function (months, year) {
        return months.map(function (monthName) {
            var date = new Date(monthName + ' ' + year);
            var label = bh.lib.util.date.humanizeDate(date, 'period', 'n');

            return {
                label: label[0].toUpperCase() + label.substring(1),
                value: makeDateValue(monthName, year)
            };
        });
    };

    var getMonths = function (yearCount, monthArray) {
        return monthArray.filter(function (month) {
            return yearCount[month];
        });
    };

    var getOptions = function (postsCount, monthArray) {
        var years = Object.keys(postsCount);

        return years.reduce(function (options, year) {
            if (isNaN(parseInt(year, 10))) {
                return options;
            }

            var months = getMonths(postsCount[year], monthArray);

            Array.prototype.push.apply(options, prepareOption(months, year));

            return options;
        }, []);
    };

    var getSelectControlContent = function (data) {
        var blog = data.blog;

        if (!blog || !blog.calendar) {
            return '';
        }

        var selectedDate = blog.calendar.checked;
        var monthArray = blog.calendar.MONTH_DICTIONARY;
        var selectedDateValue = makeDateValue(monthArray[selectedDate.month - 1],
            selectedDate.year);

        return [
            {
                block: 'button',
                mods: { theme: 'normal' },
                content: data.tag ? data.tag.displayName : bh.lib.i18n('news', 'for_all_time')
            },
            {
                elem: 'control',
                content: [
                    {
                        elem: 'option',
                        attrs: { value: 'all' },
                        content: bh.lib.i18n('news', 'for_all_time')
                    },
                    getOptions(blog.postsCount, monthArray).reverse()
                        .map(function (option) {
                            return {
                                elem: 'option',
                                attrs: {
                                    value: option.value,
                                    selected: selectedDateValue === option.value ?
                                        'selected' : false
                                },
                                content: option.label
                            };
                        })
                ]
            }
        ];
    };

    /* eslint-disable complexity */
    bh.match('news-selects-filters', function (ctx, json) {
        var data = json.data;
        var tags = data.tags;

        if (!data.posts && !data.post || !tags) {
            return;
        }

        var selectedTag = data.tag;
        var slug = selectedTag && selectedTag.slug;
        var layout = json.mods.layout || 'content';
        var tagsPopupAxis = bh.lib.global.isTouch ? 'left' : 'right';

        ctx.js({ mainPage: data.currentPath })
            .content([
                {
                    elem: 'select-row',
                    content: [
                        !data.isPumpkinResponse && {
                            elem: 'select',
                            content: {
                                block: 'select',
                                name: 'init',
                                mods: {
                                    type: 'date',
                                    size: 'm',
                                    theme: 'normal',
                                    layout: layout,
                                    width: 'available'
                                },
                                js: {
                                    rows: 10,
                                    elemPopupMods: {
                                        parent: 'select'
                                    },
                                    popupParams: {
                                        directions: [
                                            {
                                                to: 'bottom',
                                                axis: 'left',
                                                offset: { top: 8 }
                                            }
                                        ]
                                    }
                                },
                                content: getSelectControlContent(data)
                            }
                        },
                        {
                            elem: 'select',
                            content: {
                                block: 'select',
                                name: 'init',
                                mods: {
                                    type: 'tags',
                                    size: 'm',
                                    theme: 'normal',
                                    layout: layout,
                                    width: 'available'
                                },
                                js: {
                                    rows: 10,
                                    elemPopupMods: {
                                        parent: 'select',
                                        type: 'tags'
                                    },
                                    popupParams: {
                                        directions: [
                                            {
                                                to: 'bottom',
                                                axis: tagsPopupAxis,
                                                offset: { top: 8 }
                                            }
                                        ]
                                    }
                                },
                                content: [
                                    {
                                        block: 'button',
                                        mods: { theme: 'normal' },
                                        content: selectedTag ?
                                            selectedTag.displayName : bh.lib.i18n('news', 'tags')
                                    },
                                    {
                                        elem: 'control',
                                        content: [
                                            {
                                                elem: 'option',
                                                attrs: { value: 'all' },
                                                content: bh.lib.i18n('news', 'tags')
                                            },
                                            tags
                                                .filter(function (tag) {
                                                    return !tag.slug.startsWith('hidden-');
                                                })
                                                .map(function (tag) {
                                                    return {
                                                        elem: 'option',
                                                        attrs: {
                                                            value: tag.url,
                                                            selected: slug === tag.slug ?
                                                                'selected' : false
                                                        },
                                                        content: tag.displayName
                                                    };
                                                })
                                        ]
                                    }
                                ]
                            }
                        }
                    ]
                }
            ], true);
    });
    /* eslint-enable complexity */
};
