BEM.DOM.decl('news-selects-filters', {
    onSetMod: {
        js: function () {
            this._tagsSelect = this.findBlockInside({
                block: 'select',
                modName: 'type',
                modVal: 'tags'
            });

            this._dateSelect = this.findBlockInside({
                block: 'select',
                modName: 'type',
                modVal: 'date'
            });

            this._tagsSelect.on('change', this._handleTagsSelect.bind(this));

            if (this._dateSelect) {
                this._dateSelect.on('change', this._handleDateSelect.bind(this));
            }

            this.bindToWin('scroll', this._hidePopups.bind(this));
        }
    },

    _handleTagsSelect: function () {
        this._handleSelect(this._tagsSelect.val());
    },

    _handleDateSelect: function () {
        this._handleSelect(this._dateSelect.val());
    },

    _hidePopups: function () {
        this._tagsSelect.delMod('opened');

        if (this._dateSelect) {
            this._dateSelect.delMod('opened');
        }
    },

    _handleSelect: function (value) {
        var location = window.location;

        if (value === 'all') {
            location.href = this.params.mainPage;
        } else {
            location.search = value;
        }
    }
});
