module.exports = function (bh) {
    bh.match('offices__list', function (ctx) {
        var offices = ctx.param('offices');

        var list = offices.offices.map(function (office) {
            return {
                elem: 'office',
                mods: {
                    country: office.city.country,
                    hide: 'yes'
                },
                office: office,
                mapsApi: ctx.param('mapsApi')
            };
        });

        ctx.content(list);
    });

    /* eslint-disable complexity */
    bh.match('offices__office', function (ctx) {
        var office = ctx.param('office');
        var mapsApi = ctx.param('mapsApi');
        var mapExists = mapsApi && office.map && office.map.latitude && office.map.longitude;

        ctx
            .mods({
                major: mapExists ? 'yes' : false
            })
            .content([
                {
                    elem: 'office-data',
                    content: [
                        { elem: 'city', content: office.city.humanName },
                        {
                            elem: 'contacts',
                            office: office
                        },
                        office.path && {
                            elem: 'more',
                            content: {
                                block: 'link',
                                mods: { theme: 'normal' },
                                url: office.path,
                                content: bh.lib.i18n('offices', 'readmore')
                            }
                        }
                    ]
                },
                mapExists && {
                    elem: 'office-map',
                    content: {
                        block: 'map',
                        js: {
                            mapsApi: mapsApi,
                            address: office.map
                        }
                    }
                }
            ]);
    });
    /* eslint-enable complexity */

    bh.match('offices__contacts', function (ctx) {
        var office = ctx.param('office');

        ctx
            .tag('ul')
            .content([
                office.contacts.map(function (contact) {
                    return {
                        elem: 'item',
                        content: [
                            {
                                tag: 'span',
                                content: contact.name + ' '
                            },
                            {
                                tag: 'span',
                                content: contact.text
                            }
                        ]
                    };
                }),
                office.address && {
                    elem: 'item',
                    content: office.address
                }
            ]);
    });

    bh.match('offices__item', function (ctx) {
        ctx.tag('li');
    });
};
