BEM.DOM.decl('offices', {
    onSetMod: {
        js: {
            inited: function () {
                this._initOfficeElems();
                this.bindEvents();
            }
        }
    },

    onElemSetMod: {
        office: {
            hide: function () {
                this._maps.forEach(function (mapBlock) {
                    mapBlock.trigger('update');
                });
            }
        }
    },

    _initOfficeElems: function () {
        this._offices = this.elem('office');
        this._maps = this.findBlocksInside('map');

        this._control = this.findBlockInside(this.params.control);
        this._filterItems(this._control.val());
    },

    bindEvents: function () {
        this._control.on('change', function () {
            var val = this._control.val();

            this._filterItems(val);
        }.bind(this));
    },

    _filterItems: function (val) {
        this._changeState(val);

        this._offices.each(function (index, item) {
            var isMod = this.hasMod($(item), 'country', val);

            this.toggleMod($(item), 'hide', '', 'yes', isMod);
        }.bind(this));
    },

    _changeState: function (val) {
        var query = '?country=' + val;

        if (window.history && typeof (window.history.replaceState) === 'function') {
            window.history.replaceState(null, null, 'offices' + query);
        } else if (window.location.search !== query) {
            window.location.search = query;
        }
    }
});
