module.exports = function (blocks) {
    blocks.declare('offices', function (data) {
        /* eslint-disable max-len */
        var offices = data.offices;
        var selectedCountry = 'russia'; // Если нет параметра в url и не можем определить страну по домену
        var countriesList = [];
        var countries = {};

        offices.countries.forEach(function (country) {
            if (data.tld === country.tld) {
                selectedCountry = country.name;
            }

            countries[country.name] = country.humanName;
            countriesList.push(country.name);
        });

        if (data.country && countriesList.indexOf(data.country) > -1) {
            selectedCountry = data.country;
        }

        return {
            block: 'offices',
            content: [
                {
                    elem: 'controls',
                    selectedCountry: selectedCountry,
                    countries: countries
                },
                {
                    elem: 'list',
                    offices: offices,
                    mapsApi: data.mapsApi
                }
            ]
        };
    });
};
