module.exports = function (bh) {
    'use strict';
    bh.match('og', function (ctx, json) {
        if (!json.og) {
            return '';
        }

        return [
            json.og.title && {
                block: 'b-page',
                elem: 'meta',
                attrs: {
                    property: 'og:title',
                    content: json.og.title
                }
            },
            json.og.description && {
                block: 'b-page',
                elem: 'meta',
                attrs: {
                    property: 'og:description',
                    content: bh.lib.util.cutString(json.og.description, 500)
                }
            },
            json.og.image && {
                block: 'b-page',
                elem: 'meta',
                attrs: {
                    property: 'og:image',
                    content: json.og.image
                }
            }
        ];
    });
};
