module.exports = function (bh) {
    /* eslint-disable complexity */
    bh.match('online-edu-block', function (ctx, json) {
        var data = json.data;
        var title = data.title;
        var text = data.text;
        var accordion = data.accordion;
        var blocks = data.blocks;

        ctx.content([
            title && {
                elem: 'title',
                mix: { block: 'html-content' },
                content: title
            },
            text && {
                elem: 'text',
                mix: { block: 'html-content' },
                content: text
            },
            accordion && accordion.length ? {
                elem: 'accordion',
                content: {
                    block: 'accordion',
                    items: accordion,
                    goalId: json.goalId
                }
            } : null,
            blocks.enabled && {
                elem: 'blocks',
                content: {
                    block: 'cards-block',
                    data: blocks
                }
            }
        ]);
    });
    /* eslint-enable complexity */
};
