module.exports = function (bh) {
    /* eslint-disable complexity */
    bh.match('online-edu-lesson', function (ctx, json) {
        var data = json.data;
        var previewImage = data.previewImage;
        var title = data.title;
        var image = data.image;
        var tagline = data.tagline;
        var text = data.text;

        ctx
            .js(true)
            .content([
                previewImage && {
                    elem: 'image',
                    mods: { type: 'preview' },
                    image: previewImage,
                    title: title
                },
                title && {
                    elem: 'title',
                    tag: 'h1',
                    content: title
                },
                image && {
                    elem: 'image',
                    mods: { type: 'content' },
                    image: image,
                    title: title
                },
                tagline && {
                    elem: 'tagline',
                    tag: 'h2',
                    content: tagline
                },
                text && {
                    elem: 'text',
                    mix: { block: 'html-content' },
                    content: text
                }
            ]);
    });
    /* eslint-enable complexity */

    bh.match('online-edu-lesson__image', function (ctx, json) {
        var image = json.image;
        var title = json.title;

        if (!image) {
            return '';
        }

        ctx
            .tag('img')
            .attrs({
                alt: title,
                src: image,
                title: title
            });
    });
};
