module.exports = function (bh) {
    /* eslint-disable complexity */
    bh.match('online-edu-service', function (ctx, json) {
        var data = json.data;
        var name = data.name;
        var icon = data.icon;
        var content = data.content;
        var cta = data.cta;

        ctx
            .js(true)
            .content([
                (name || icon) && {
                    elem: 'head',
                    name: data.name,
                    icon: data.icon
                },
                content && content.length ? {
                    elem: 'content',
                    items: content,
                    goalId: data.metrikaGoalId
                } : null,
                cta.enabled && {
                    elem: 'cta',
                    content: {
                        block: 'product-cta-3',
                        data: cta
                    }
                }
            ]);
    });
    /* eslint-enable complexity */

    bh.match('online-edu-service__head', function (ctx, json) {
        var name = json.name;

        ctx.content([
            ctx.content(),
            name && {
                elem: 'name',
                tag: 'h1',
                content: name
            }
        ], true);
    });

    bh.match('online-edu-service__content', function (ctx, json) {
        ctx.content(json.items.map(function (item) {
            return {
                block: 'online-edu-block',
                data: item,
                goalId: json.goalId
            };
        }));
    });
};
