module.exports = function (bh) {
    bh.match('order-list', function (ctx, json) {
        var order = json.order;

        ctx.content([
            order.sections.length > 1 && {
                elem: 'switcher',
                current: order.currentSection,
                sections: order.sections
            },
            order.sections.map(function (section) {
                return {
                    elem: 'method',
                    js: {
                        url: section.url
                    },
                    elemMods: {
                        type: section.id,
                        visibility: order.currentSection === section.id && 'visible'
                    },
                    content: {
                        block: 'order-method',
                        mods: { type: section.mod },
                        data: section,
                        filterUrl: json.filterUrl,
                        searchUrl: json.searchUrl
                    }
                };
            })
        ]);
    });
};
