BEM.DOM.decl('order-list', {
    onSetMod: {
        js: function () {
            this._switcher = this.findBlockInside(this.params.control);
            this._methods = this.elem('method');

            if (this._switcher) {
                var name = this._switcher.val();

                BEM.blocks['i-bem'].replaceUrl({ name: name }, 'order',
                    this.elemParams(this.elem('method', 'type', name)).url);

                this.bindEvents();
            }
        }
    },

    /**
     * Переключает контент
     * @param {String} name
     */
    switchContent: function (name) {
        this.delMod(this._methods, 'visibility');
        var currentMethod = this.elem('method', 'type', name);

        this.setMod(currentMethod, 'visibility', 'visible');
    },

    bindToSwitcher: function () {
        this._switcher.on('change', function () {
            var name = this._switcher.val();

            this.switchContent(name);
            BEM.blocks['i-bem'].changeUrl({ name: name }, 'order',
                this.elemParams(this.elem('method', 'type', name)).url);
        }, this);
    },

    bindEvents: function () {
        this.bindToSwitcher();
        this.bindToWin('popstate', function (e) {
            var name = e.originalEvent.state.name;

            // Отписываемся от события что бы при выставления значения не менялась история
            this._switcher.un('change');
            this._switcher.val(name);
            this.switchContent(name);
            this.bindToSwitcher();
        });
    }
});
