module.exports = function (bh) {
    bh.match('order-method_type_manager', function (ctx) {
        var data = ctx.param('data');

        ctx.content([
            {
                elem: 'columns-wrapper',
                data: data.text
            },
            {
                elem: 'form',
                content: {
                    block: 'contact-form',
                    js: {
                        orderId: {
                            page: data.page,
                            section: data.id
                        },
                        url: bh.lib.global.contactFormPath,
                        metrikaGoalId: 'form_cta_manager',
                        formName: data.page + '_' + data.id
                    },
                    fields: data.fields,
                    agreements: data.agreements,
                    attachItems: data.attachItems,
                    button: {
                        text: bh.lib.i18n('order', 'sendForm'),
                        align: 'center'
                    },
                    hasCaptcha: true
                }
            }
        ]);
    });

    bh.match('order-method_type_manager__columns-wrapper', function (ctx) {
        var text = ctx.param('data');

        if (!text || !text.length) {
            return '';
        }

        text = text.slice(0, 2);

        ctx.content(text.map(function (item) {
            return {
                elem: 'text-column',
                mods: { wide: text.length === 1 ? 'yes' : false },
                content: item
            };
        }));
    });
};
